# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 5
# Experiment: PMxPM, Run: 5
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR5_strategy.txt
# LLM Suggested Fallback: D

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR5(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    
    # Round 1: Cooperate to establish trust
    if current_round == 1:
        return "C"
    
    # Check if opponent's code suggests defection in Round 10
    opponent_defect_10 = ("current_round == 10" in opponent_program_code and "return 'D'" in opponent_program_code)
    
    # Round 10: Defect unconditionally or if opponent is likely to defect
    if current_round == 10:
        return "D"
    
    # Rounds 2-7: Modified Tit-for-Tat with forgiveness
    if 2 <= current_round <= 7:
        if opp_history[-1] == "D":
            return "D" if random.random() < 0.8 else "C"
        else:
            return "C"
    
    # Rounds 8-9: Cautious defection based on opponent's recent behavior
    if 8 <= current_round <= 9:
        recent_defections = sum(1 for move in opp_history[-5:] if move == "D")
        if recent_defections > 2:
            return "D"
        else:
            if opp_history[-1] == "D":
                return "D" if random.random() < 0.9 else "C"
            else:
                return "C"
    
    # Fallback (should not reach here)
    return "C"